// ver01.11.16.1858
//D8 pin -  (PLANSHpin pin)(выход 5в логический) (выключает питание планшета!(R13-R14))
//D7 pin - самозапитка (AKB pin) (выход 5в логический)


/*ноги ардуины*/
int PLANSHpin = 8; //управление на выключатель питания БАТАРЕИ планшета через управляющую ногу ss\sd1
//0 = нет питания; 1 = есть питание ( БАТАРЕИ планшета)
int SAMOZAPITKApin = 7; //управление транзюком самозапитки блока питания VT2 
//1 = есть самозапитка; 0 = нет самозапитки
int OTGpin = 10; //управление транзюком OTG VT3
//1 = есть масса на OTG; 0 = нет массы на OTG
int SLEEPpin = 11; //управление транзюком сна VT4 (на датчик холла))
//1 = потух экран(есть масса на пине сна); 0 = штатная работа планшета (нет массы на пине сна)
int POGOpin = 9; //управление транзюком питания  +5V (VT5) на пого пин, чтоб планшет думал, что идет зарядка 
//1 = нет 5V на POGO; 0 = есть 5V на POGO
int REMpin = 12; // //управление транзюком VT7 и через него VT6 = выход сигнала REM (+12v) НЕ АКТИВИРОВАЛ В СКЕТЧЕ, на плате распаяно.
//0 = нет 12В на выходе REM; 1 = есть 12В на выходе REM
byte flagREM = 0; /* признак включенного выхода на усилитель звука (REM) 0 1 2*/
/*логические переменные, используемые в коде*/
int flagACC = 0; //признак включенного зажигания 
int flagAKB = 0; // признак заряженной батареи
int flagHALL = 0; //флаг отработки морга экрана при холодном старте( flagHALL = 1 экран можно включать и выключать, датчик холла на планшете инициализировался)
/*счётчики времени*/
unsigned long eventTime = 0;
unsigned long pauseTimeACC = 0;
unsigned long pauseTimeAKB = 0;  //время отсчёта самозапитки
unsigned long pauseTimeHALL = 120000; // время паузы перед морганием экрана (для датчика холла)(равен времени загрузки планшета плюс секунд 10-20)= 2мин
unsigned long timeBeforeRemOff = 1800000; /*1800000=30мин. Время, оставшееся до отключения выхода REM после включения зажигания и незаводки машины. 209 строчка.*/
unsigned long TimerREM = 0; /* отсчет до выключения выхода REM при заглушенном авто и включенном зажигании.3600000 = час */

void setup() 
{
  // put your setup code here, to run once:
 pinMode(PLANSHpin, OUTPUT);
 pinMode(SAMOZAPITKApin, OUTPUT);
 pinMode(OTGpin, OUTPUT);
 pinMode(SLEEPpin, OUTPUT);
 pinMode(POGOpin, OUTPUT);
 pinMode(13, OUTPUT); //светодиодик на плате ардуины
 analogReference(INTERNAL);  //перевод напряжения делителя на внутреннее значение 1,1В ( для повышения точности замера Uacc и Uakb)
 pinMode(REMpin, OUTPUT);
// Serial.begin(1200);
}


void loop()
{//void loop()
int Uacc = analogRead (A7); //Читаем напругу с делителя R10-R11
int Uakb = analogRead (A6); //Читаем напругу с делителя R2-R3

float U_acc_real = Uacc * (1.1 / 1023.0*17.2);  //Вычисляем реальное напряжение +ACC на входе делителя (A7) 17.2=поправка на погрешность делителя. обкатывать только на реальном питании от 12В! при питании от ЮСБ 5,0В плавают
float U_akb_real = Uakb * (1.1 / 1023.0*17.1);  //Вычисляем реальное напряжение +30 на входе делителя (A6)
                                             
                                                 
 // кусок кода ниже нужен для того, чтобы при включении  и сразу выключении ACC при полностью выключенном планшете(холодный старт) экран мог тухнуть по сигналу датчика холла.
 if (millis() > pauseTimeHALL && flagHALL == 0 || millis() > 10000 && flagACC == 1)  //проверка отсчета при холодном старте 
  {flagHALL = 1;} //проверка отсчета при холодном старте при включении  и сразу выключении ACC





 //  ------------========================== блок ACC ========================-----------------------------------------------------------------------------
if (U_acc_real>= 12 && flagACC == 0 && flagAKB == 1) //проверка напруги АСС и АКБ при флаге ACC = 0
   {
   
   flagACC = 1;  //ВКлючили зажигание
   pauseTimeACC = millis();
   //сразу после включения зажигания даём минус на Y-OTG и плюс +5V на POGO или USB. 
   digitalWrite(OTGpin, 1); //включаем минус на Y-OTG (8 pin PW1) (включается хаб? и звуковая карта)
   digitalWrite(POGOpin, 0); //включаем +5V (3 pin PW1 = POGO) нужно для распознавания планшетом признака зарядки. ( можно подавать на +5В USB кабеля (для тимуровской прошивки или если не используется датчик холла) 
   
   }
 if (millis()-pauseTimeACC>=2000 && flagACC == 1) // пауза 2c после включения ACC и потом делать следующ(пока включено ACC):
   {
   digitalWrite(SLEEPpin, 0); //вЫключаем минус на упр SLEEP (7 pin PW1) = включаем экран
                          // REM УПРАВЛЕНИЕ РАСКОММЕНТИТЬ и протестировать 
   
    if( flagREM == 1  && flagAKB == 1   ){digitalWrite(REMpin, 1);} /* включаем выход REM*/ // даем + на управление VT7, тот дает минус на управление VT6,  а VT6 выдаёт +12V на выход (PW1 - 13 pin)) 
   pauseTimeACC = 0;
   } 

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~обработка статуса выхода REM~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*если напруга батареи больше 12В, то включаем еще и усилитель звука (выход REM) /но включаем его только на 1 час, если не заведены.*/

    if (U_akb_real >= 11.8 && flagACC == 1 && flagREM == 0) {flagREM = 1; TimerREM = millis();} /*если подзаряжен акб и включили зажигание  - ВКЛЮЧАЕМ REM*/
    if (U_akb_real >= 11.8 && flagACC == 1 && ( millis() - TimerREM >= timeBeforeRemOff )) {flagREM = 2 ;}  /*  если кончилось время обратного отсчета - статус рем - 2.*/
    if (U_akb_real > 13.7){ (flagREM = 1);TimerREM = millis();} /* если завели машину, - ВКЛЮЧАЕМ REM, и постоянно обнуляем обратный отсчет вырубания РЕМ.*/
    if (U_akb_real >= 11.8 && flagREM == 2 && flagACC == 0){ flagREM = 0;} /* если восстановилось напряжение при выключенном зажигании - обнуляем статус РЕМ.*/
    if (U_akb_real < 11.8 && flagACC == 1){ flagREM = 2;} /*если подсел акб при включенном зажигании - статус рем - 2.*/
    if( flagREM == 0 ||  flagREM == 2){digitalWrite(REMpin, 0);}  /* выключаем выход REM*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~конец отработки выхода REM~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
   
   
if (U_acc_real< 11 && flagACC == 1)
   {
   flagACC = 0;  //Выключили зажигание
   pauseTimeACC = millis();
   pauseTimeAKB = millis(); // сброс времени для отсчета отключения самозапитки 
   flagREM = 0; /* выключаем флаг выхода REM*/
   digitalWrite(REMpin, 0); // даем - на управление VT7, тот убирает за счет подтяжки R24 минус на управление VT6,  а VT6 убирает +12V на выход (PW1 - 13 pin)) 
   }   
   
   if (millis()-pauseTimeACC>=4000 && flagACC == 0) //пауза 4c после вЫключения ACC и потом делать следующ:
   {
   
   digitalWrite(OTGpin, 0); //вЫключаем минус на Y-OTG (8 pin PW1)
   digitalWrite(POGOpin, 1); //вЫключаем +5V (3 pin PW1 = POGO)
   pauseTimeACC = 0;
   if (flagHALL==1){digitalWrite(SLEEPpin, 1);} else {digitalWrite(SLEEPpin, 0);}  //включаем минус на SLEEP (7 pin PW1)при этом тухнет экран (если прошло 2 минуты с момента включения ардуины)
   } 



   
                                                           //  .. блок АКБ (самозапитки)
if (U_akb_real>=12 && flagAKB == 0)  //проверка +30 и флага акб
    {
   digitalWrite(SAMOZAPITKApin, 1);  // включаем самозапитку
   digitalWrite(PLANSHpin, 1);  //включаем питание на батарею планшета (ss\sd1)
   flagAKB = 1;
    }
if (U_akb_real<12 && flagAKB == 1) // ситуация, когда сел при работе ардуины аккумулятор 
    {
      flagAKB = 0;
    }     
    
if (millis()-pauseTimeAKB>=15000 && flagAKB == 0) // если севший аакумулятор     
   {                                              // пауза 15c
   digitalWrite(PLANSHpin, 0);  //вЫключаем питание на батарею планшета (ss\sd1)
   digitalWrite(SAMOZAPITKApin, 0);  //выключаем SAMOZAPITKApin, при этом пропадает питание через полевик на KIW, система ПОЛНОСТЬЮ обесточивается
   delay (3000);              // задержка для аппаратного выключения
   } 
 
if (flagAKB == 1 && flagACC == 0)  //ситуация, когда норм акб и давно выключили зажигание (ACC)
   {
   if (millis()-pauseTimeAKB>=18000000 && flagAKB == 1) // если давно выключили ACC    
   {                                              // пауза  (3600000 - 60мин) (60000 - 1 мин)(10800000=3ч)18000000=5ч
   digitalWrite(SAMOZAPITKApin, 0);  //выключаем SAMOZAPITKApin, при этом пропадает питание через полевик на KIW, система ПОЛНОСТЬЮ обесточивается
   digitalWrite(PLANSHpin, 0);  //вЫключаем питание на батарею планшета (ss\sd1)
   delay (3000);              // задержка для аппаратного выключения
   }    
    }
    
if (flagAKB ==0 ){digitalWrite(13, 0);} else {digitalWrite(13, 1);};   // индикация напруги батареи на ардуинине.

}//void loop()

